/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.mantle.util.JsonHelper;

public class FluidContainerIngredient
implements CustomIngredient {
    public static final class_2960 ID = Mantle.getResource("fluid_container");
    public static final Serializer SERIALIZER = new Serializer();
    private final FluidIngredient fluidIngredient;
    @Nullable
    private final class_1856 display;
    private class_1799[] displayStacks;

    protected FluidContainerIngredient(FluidIngredient fluidIngredient, @Nullable class_1856 display) {
        this.fluidIngredient = fluidIngredient;
        this.display = display;
    }

    public static FluidContainerIngredient fromIngredient(FluidIngredient ingredient, class_1856 display) {
        return new FluidContainerIngredient(ingredient, display);
    }

    public static FluidContainerIngredient fromIngredient(FluidIngredient ingredient) {
        return new FluidContainerIngredient(ingredient, null);
    }

    public static FluidContainerIngredient fromFluid(FluidObject<?> fluid, boolean forgeTag) {
        return FluidContainerIngredient.fromIngredient(FluidIngredient.of(forgeTag ? fluid.getForgeTag() : fluid.getLocalTag(), 81000L), class_1856.method_8091((class_1935[])new class_1935[]{fluid}));
    }

    public boolean test(@Nullable class_1799 stack) {
        return stack != null && !stack.method_7960() && Optional.ofNullable((Storage)FluidStorage.ITEM.find(stack, (Object)ContainerItemContext.withConstant((class_1799)stack))).flatMap(cap -> {
            FluidStack contained = TransferUtil.getFirstFluid((Storage)cap);
            if (!contained.isEmpty() && this.fluidIngredient.getAmount(contained.getFluid()) == contained.getAmount() && this.fluidIngredient.test(contained.getFluid())) {
                class_1799 copy = ItemHandlerHelper.copyStackWithSize((class_1799)stack, (int)1);
                return Optional.ofNullable(copy);
            }
            return Optional.empty();
        }).filter(cap -> {
            class_3611 fluid;
            long amount;
            Storage storage = (Storage)FluidStorage.ITEM.find(cap, (Object)ContainerItemContext.withConstant((class_1799)cap));
            FluidStack drained = TransferUtil.extractAnyFluid((Storage)storage, (long)(amount = this.fluidIngredient.getAmount(fluid = TransferUtil.getFirstFluid((Storage)storage).getFluid())));
            return drained.getFluid() == fluid && drained.getAmount() == amount && class_1799.method_7973((class_1799)stack.method_7909().method_7858().method_7854(), (class_1799)cap);
        }).isPresent();
    }

    public boolean requiresTesting() {
        return true;
    }

    public List<class_1799> getMatchingStacks() {
        if (this.displayStacks == null) {
            this.displayStacks = this.display == null ? new class_1799[0] : this.display.method_8105();
        }
        return List.of(this.displayStacks);
    }

    public Serializer getSerializer() {
        return SERIALIZER;
    }

    private static class Serializer
    implements CustomIngredientSerializer<FluidContainerIngredient> {
        private Serializer() {
        }

        public class_2960 getIdentifier() {
            return ID;
        }

        public void write(JsonObject jsonObject, FluidContainerIngredient ingredient) {
            JsonObject json;
            JsonElement element = ingredient.fluidIngredient.serialize();
            if (element.isJsonObject()) {
                json = element.getAsJsonObject();
            } else {
                json = new JsonObject();
                json.add("fluid", element);
            }
            json.addProperty("type", ID.toString());
            if (ingredient.display != null) {
                json.add("display", ingredient.display.method_8089());
            }
            jsonObject.add("fluid", (JsonElement)json);
        }

        public void write(class_2540 buffer, FluidContainerIngredient ingredient) {
            ingredient.fluidIngredient.write(buffer);
            if (ingredient.display != null) {
                buffer.writeBoolean(true);
                ingredient.display.method_8088(buffer);
            } else {
                buffer.writeBoolean(false);
            }
        }

        public FluidContainerIngredient read(JsonObject json) {
            FluidIngredient fluidIngredient = (json = json.getAsJsonObject("fluid")).has("fluid") ? FluidIngredient.deserialize(json, "fluid") : FluidIngredient.deserialize((JsonElement)json, "fluid");
            class_1856 display = null;
            if (json.has("display")) {
                display = class_1856.method_52177((JsonElement)JsonHelper.getElement(json, "display"));
            }
            return new FluidContainerIngredient(fluidIngredient, display);
        }

        public FluidContainerIngredient read(class_2540 buffer) {
            FluidIngredient fluidIngredient = FluidIngredient.read(buffer);
            class_1856 display = null;
            if (buffer.readBoolean()) {
                display = class_1856.method_8086((class_2540)buffer);
            }
            return new FluidContainerIngredient(fluidIngredient, display);
        }
    }
}

